#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("pheatmap")

#???ð?
library(limma)
library(pheatmap)
rm(list = ls(all=T))
inputFile="expMatrix.csv"        #?????ļ?
fdrFilter=0.05                   #fdr?ٽ?ֵ
logFCfilter=2                    #logFC?ٽ?ֵ
conFile="sample1.csv"            #????????Ʒ
treatFile="sample2.csv"          #ʵ??????Ʒ
setwd("C:/Users/马明福1/Desktop/新建文件夹 (2)")     #???ù???Ŀ¼

#??ȡ?????ļ????????????ļ?????
rt=read.table(inputFile,sep=",",header=T,check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
data=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
data=avereps(data)
data=data[rowMeans(data)>0.1,]

#??ȡ??Ʒ??Ϣ
sample1=read.table(conFile,sep="\t",header=F,check.names=F)
sample2=read.table(treatFile,sep="\t",header=F,check.names=F)
conData=data[,as.vector(sample1[,1])]
treatData=data[,as.vector(sample2[,1])]
data=cbind(conData,treatData)
conNum=ncol(conData)
treatNum=ncol(treatData)
type=c(rep(1,conNum),rep(2,treatNum))

#????????
outTab=data.frame()
for(i in row.names(data)){
	if(sd(data[i,1:conNum])==0){
		data[i,1]=0.001
	}
	if(sd(data[i,(conNum+1):(conNum+treatNum)])==0){
		data[i,(conNum+1)]=0.001
	}
	geneName=i
	rt=data.frame(expression=data[i,],type=type)
	wilcoxTest<-wilcox.test(expression ~ type, data=rt)
	conGeneMeans=mean(data[i,1:conNum])
	treatGeneMeans=mean(data[i,(conNum+1):ncol(data)])
	logFC=log2(treatGeneMeans)-log2(conGeneMeans)
	pvalue=wilcoxTest$p.value
	conMed=median(data[i,1:conNum])
	treatMed=median(data[i,(conNum+1):ncol(data)])
	diffMed=treatMed-conMed
	if( ((logFC>0) & (diffMed>0)) | ((logFC<0) & (diffMed<0)) ){  
		outTab=rbind(outTab,cbind(gene=i,logFC=logFC,conMean=conGeneMeans,treatMean=treatGeneMeans,pValue=pvalue))
	}
}
pValue=outTab[,"pValue"]
fdr=p.adjust(as.numeric(as.vector(pValue)),method="fdr")
outTab=cbind(outTab,fdr=fdr)

#???????л????Ĳ???????
write.table(outTab,file="all.xls",sep="\t",row.names=F,quote=F)

#????????????
outDiff=outTab[( abs(as.numeric(as.vector(outTab$logFC)))>logFCfilter & as.numeric(as.vector(outTab$fdr))<fdrFilter),]
write.table(outDiff,file="diff.xls",sep="\t",row.names=F,quote=F)
write.table(outDiff,file="diff.txt",sep="\t",row.names=F,quote=F)

#?????????ı????ļ?
heatmap=rbind(ID=colnames(data[as.vector(outDiff[,1]),]),data[as.vector(outDiff[,1]),])
write.table(heatmap,file="diffGeneExp.txt",sep="\t",col.names=F,quote=F)

#???Ʋ?????????ͼ
geneNum=50
diffSig=outDiff[order(as.numeric(as.vector(outDiff$logFC))),]
diffGeneName=as.vector(diffSig[,1])
diffLength=length(diffGeneName)
hmGene=c()
if(diffLength>(geneNum*2) ){
    hmGene=diffGeneName[c(1:geneNum,(diffLength-geneNum+1):diffLength)]
}else{
    hmGene=diffGeneName
}
hmExp=data[hmGene,]
Type=c(rep("Con",conNum),rep("Treat",treatNum))
names(Type)=colnames(data)
Type=as.data.frame(Type)
pdf(file="heatmap.pdf",height=7,width=8)
pheatmap(hmExp, 
         annotation=Type, 
         color = colorRampPalette(c("blue", "white", "red"))(50),
         cluster_cols =F,
         show_colnames = F,
         scale="row",
         fontsize = 8,
         fontsize_row=6,
         fontsize_col=8)
dev.off()


######??????ѧ??: https://www.biowolf.cn/
######?γ???1: https://shop119322454.taobao.com
######?γ???2: https://ke.biowolf.cn
######?γ???3: https://ke.biowolf.cn/mobile
######?⿡??ʦ???䣺seqbio@foxmail.com
######?⿡??ʦ΢??: seqBio
